<?php
header('Content-Type: application/json; charset=utf-8');

// -------------------------
// تنظیمات کش
// -------------------------
$cacheFile = __DIR__ . '/cache_servers.json'; // فایل کش
$cacheLifetime = 5 * 60; // مدت اعتبار کش (۵ دقیقه)

// -------------------------
// تابع دریافت داده از API
// -------------------------
function fetchServersFromAPI() {
    $url = "https://ox13.appsongplay.com/ox-13/all?country=Iran&debug=false&package=com.vpn.oxvpn&remoteIp=null";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64)");
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $raw = curl_exec($ch);

    $err = curl_error($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($raw === false || $code >= 400) {
        return ["error" => "fetch_failed", "http" => $code, "curl" => $err];
    }

    return json_decode($raw, true);
}

// -------------------------
// مرحله ۱: بررسی کش
// -------------------------
$useCache = false;
if (file_exists($cacheFile)) {
    $age = time() - filemtime($cacheFile);

    if ($age < $cacheLifetime) {
        $cached = json_decode(file_get_contents($cacheFile), true);
        if (is_array($cached) && isset($cached['servers'])) {
            $useCache = true;
            $servers = $cached['servers'];
        }
    }
}

// -------------------------
// مرحله ۲: اگر کش نبود -> دریافت از API
// -------------------------
if (!$useCache) {
    $api = fetchServersFromAPI();

    if (!isset($api['servers']) || !is_array($api['servers']) || count($api['servers']) == 0) {
        echo json_encode(["error" => "no_servers_found"]);
        exit;
    }

    // ذخیره در کش *همان خام دریافتی*
    file_put_contents($cacheFile, json_encode($api, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));

    $servers = $api['servers'];
}

// -------------------------
// مرحله ۳: انتخاب تصادفی سرور
// -------------------------
$index = array_rand($servers);
$chosen = $servers[$index];

// -------------------------
// مرحله ۴: چاپ دقیق config
// -------------------------
if (!isset($chosen['config'])) {
    echo json_encode(["error" => "no_config_in_server"]);
    exit;
}

// این رشته JSON خام و unescaped است — دقیقاً همان را خروجی می‌دهیم
echo $chosen['config'];
exit;